;original java code by Jared "BlueThen" C. -> http://www.openprocessing.org/sketch/5671
;converted to AutoIt by UEZ 2014

#pragma compile(Icon, "AutoIt_Main_v10_48x48_only_RGB-A.ico")
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/so /pe /rm
#AutoIt3Wrapper_Run_After=del /f /q "%scriptdir%\%scriptfile%_stripped.au3"

#include <GDIPlus.au3>
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>

Opt("GUIOnEventMode", 1)

_GDIPlus_Startup()

Global $ghGDIPDll = $__g_hGDIPDll
Global Const $iW = 500, $iH = 500, $sTitle = "GDI+ Wavy  converted to AutoIt by UEZ / FPS: "
Global Const $hGUI = GUICreate($sTitle & "0", $iW, $iH)
GUISetState()

Global Const $hBmp = _GDIPlus_BitmapCreateFromScan0($iW, $iH)
Global Const $hHBITMAP = _GDIPlus_BitmapCreateHBITMAPFromBitmap($hBmp)
_GDIPlus_BitmapDispose($hBmp)
Global Const $hDC  = _WinAPI_GetDC($hGUI)
Global Const $hDC_Backbuffer  = _WinAPI_CreateCompatibleDC($hDC)
Global Const $DC_Obj = _WinAPI_SelectObject($hDC_Backbuffer, $hHBITMAP)
Global Const $hGfxCtx = _GDIPlus_GraphicsCreateFromHDC($hDC_Backbuffer)
_GDIPlus_GraphicsSetSmoothingMode($hGfxCtx, 4)
_GDIPlus_GraphicsSetPixelOffsetMode($hGfxCtx, 4)

Global Const $hBrush = _GDIPlus_BrushCreateSolid(), $hBrushL = _GDIPlus_BrushCreateSolid(0xFF555555), $hBrushR = _GDIPlus_BrushCreateSolid(0xFFAAAAAA), $hPen = _GDIPlus_PenCreate(0xFF000000), $hPath = _GDIPlus_PathCreate()
GUISetOnEvent($GUI_EVENT_Close, "_Exit")

Global Const $halfw = $iW / 2, $halfh = $iH / 2, $iSquares = 14, $iSquareshalf = $iSquares / 2, $iHeight = 40, $iSize = 17, $iSizehalf = $iSize / 2, $iCount = 4
Global $x, $y, $z, $a = 9999998, $xm, $xt, $zm, $zt, $isox1, $isoy1, $isox2, $isoy2, $isox3, $isoy3, $isox4, $isoy4, $iColor, $iFPS = 0
Global $fSpeed = 0.1, $fPhase = 0.55, $fPerspective = 0.5, $fPower = 24
Global $tPoints = DllStructCreate("float coordinates[" & $iCount * 2 & "]")
Global Const $ghGDI32Dll = DllOpen("gdi32.dll")

AdlibRegister("ShowFPS", 1000)

Do
	$a -= $fSpeed
	DllCall($__g_hGDIPDll, "int", "GdipGraphicsClear", "handle", $hGfxCtx, "dword", 0xF0101010)
	For	$x = -$iSquareshalf To $iSquareshalf - 1
		For $z = -$iSquareshalf To $iSquareshalf - 1
			$y = ($fPower * Sin($fPhase * Sqrt((0 - $x) * (0 - $x) + (0 - $z) * (0 - $z)) + $a))
			$xm = $x * $iSize - $iSizehalf
			$xt = $x * $iSize + $iSizehalf
			$zm = $z * $iSize - $iSizehalf
			$zt = $z * $iSize + $iSizehalf

			$isox1 = ($xm - $zm + $halfw)
			$isoy1 = (($xm + $zm) * $fPerspective + $halfh)
			$isox2 = ($xm - $zt + $halfw)
			$isoy2 = (($xm + $zt) * $fPerspective + $halfh)
			$isox3 = ($xt - $zt + $halfw)
			$isoy3 = (($xt + $zt) * $fPerspective + $halfh)
			$isox4 = ($xt - $zm + $halfw)
			$isoy4 = (($xt + $zm) * $fPerspective + $halfh)


			;draw left side
			$tPoints.coordinates((1)) = $isox2
			$tPoints.coordinates((2)) = $isoy2 - $y
			$tPoints.coordinates((3)) = $isox3
			$tPoints.coordinates((4)) = $isoy3 - $y
			$tPoints.coordinates((5)) = $isox3
			$tPoints.coordinates((6)) = $isoy3 + $iHeight
			$tPoints.coordinates((7)) = $isox2
			$tPoints.coordinates((8)) = $isoy2 + $iHeight
			DllCall($__g_hGDIPDll, "int", "GdipResetPath", "handle", $hPath)
			DllCall($__g_hGDIPDll, "int", "GdipAddPathPolygon", "handle", $hPath, "struct*", $tPoints, "int", $iCount)
;~ 			DllCall($__g_hGDIPDll, "int", "GdipDrawPath", "handle", $hGfxCtx, "handle", $hPen, "handle", $hPath)
			DllCall($__g_hGDIPDll, "int", "GdipFillPath", "handle", $hGfxCtx, "handle", $hBrushL, "handle", $hPath)


			;draw right side
			$tPoints.coordinates((1)) = $isox3
			$tPoints.coordinates((2)) = $isoy3 - $y
			$tPoints.coordinates((3)) = $isox4
			$tPoints.coordinates((4)) = $isoy4 - $y
			$tPoints.coordinates((5)) = $isox4
			$tPoints.coordinates((6)) = $isoy4 + $iHeight
			$tPoints.coordinates((7)) = $isox3
			$tPoints.coordinates((8)) = $isoy3 + $iHeight
			DllCall($__g_hGDIPDll, "int", "GdipResetPath", "handle", $hPath)
			DllCall($__g_hGDIPDll, "int", "GdipAddPathPolygon", "handle", $hPath, "struct*", $tPoints, "int", $iCount)
;~ 			DllCall($__g_hGDIPDll, "int", "GdipDrawPath", "handle", $hGfxCtx, "handle", $hPen, "handle", $hPath)
			DllCall($__g_hGDIPDll, "int", "GdipFillPath", "handle", $hGfxCtx, "handle", $hBrushR, "handle", $hPath)


			;draw top rectangle
			$tPoints.coordinates((1)) = $isox1
			$tPoints.coordinates((2)) = $isoy1 - $y
			$tPoints.coordinates((3)) = $isox2
			$tPoints.coordinates((4)) = $isoy2 - $y
			$tPoints.coordinates((5)) = $isox3
			$tPoints.coordinates((6)) = $isoy3 - $y
			$tPoints.coordinates((7)) = $isox4
			$tPoints.coordinates((8)) = $isoy4 - $y
			$iColor = Int((4 + $y * 0.066666) * 48)
			$iColor = $iColor < 0x00 ? 0x00 : $iColor > 0xFF ? 0xFF : $iColor
			DllCall($__g_hGDIPDll, "int", "GdipSetSolidFillColor", "handle", $hBrush, "dword", 0xFF000000 + $iColor * 0x10000 + $iColor * 0x100 + $iColor)
			DllCall($__g_hGDIPDll, "int", "GdipResetPath", "handle", $hPath)
			DllCall($__g_hGDIPDll, "int", "GdipAddPathPolygon", "handle", $hPath, "struct*", $tPoints, "int", $iCount)
;~ 			DllCall($__g_hGDIPDll, "int", "GdipDrawPath", "handle", $hGfxCtx, "handle", $hPen, "handle", $hPath)
			DllCall($__g_hGDIPDll, "int", "GdipFillPath", "handle", $hGfxCtx, "handle", $hBrush, "handle", $hPath)
		Next
	Next
	DllCall($ghGDI32Dll, "bool", "BitBlt", "ptr", $hDC, "int", 0, "int", 0, "int", $iW, "int", $iH, "ptr", $hDC_Backbuffer, "int", 0, "int", 0, "dword", $SRCCOPY)
	$iFPS += 1
Until False * Sleep(10)

Func ShowFPS()
	WinSetTitle($hGUI, "", $sTitle & $iFPS)
	$iFPS = 0
EndFunc

Func _Exit()
	AdlibUnRegister("ShowFPS")
	_GDIPlus_PathDispose($hPath)
	_GDIPlus_BrushDispose($hBrush)
	_GDIPlus_BrushDispose($hBrushL)
	_GDIPlus_BrushDispose($hBrushR)
	_GDIPlus_PenDispose($hPen)
	_WinAPI_SelectObject($hDC_Backbuffer, $DC_Obj)
	_GDIPlus_GraphicsDispose($hGfxCtx)
	_WinAPI_DeleteObject($hHBITMAP)
	_WinAPI_ReleaseDC($hGUI, $hDC)
	_GDIPlus_Shutdown()
	GUIDelete($hGUI)
	DllClose($ghGDI32Dll)
	Exit
EndFunc